/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import java.util.HashMap;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.gastabien.model.SummaryBodyTableModel;

public class MultipleUndoableEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Map<Integer[], String[]> values;
    private SummaryBodyTableModel tableModel;
    private static int increment = 0;
    private int id;

    public MultipleUndoableEdit(SummaryBodyTableModel tableModel) {
        this.tableModel = tableModel;
        this.values = new HashMap<Integer[], String[]>();
        this.id = increment++;
        System.out.println("undoable created (" + this.id + ")");
    }

    public void addCell(int rowIndex, int columnIndex, String oldValue, String newValue) {
        this.values.put(new Integer[]{rowIndex, columnIndex}, new String[]{oldValue, newValue});
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        System.out.println("redo (" + this.id + ")");
        for (Map.Entry<Integer[], String[]> entry : this.values.entrySet()) {
            this.tableModel.setValueAt(entry.getValue()[1], entry.getKey()[0], entry.getKey()[1], false);
        }
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        System.out.println("undo (" + this.id + ")");
        for (Map.Entry<Integer[], String[]> entry : this.values.entrySet()) {
            this.tableModel.setValueAt(entry.getValue()[0], entry.getKey()[0], entry.getKey()[1], false);
        }
        this.tableModel.fireTableDataChanged();
    }
}

