/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

public class OrderItem {
    private String id;
    private String description;
    private String unit;
    private double price;
    private double packageWeight;
    private double orderedPackages;
    private double totalWeight;
    private double actualTotalWeight;
    private boolean finished;

    public OrderItem(String id, String description, double price, String unit, double packageWeight, double orderedPackages, boolean finished) {
        this.id = id;
        this.description = description;
        this.price = price;
        this.unit = unit;
        this.packageWeight = packageWeight;
        this.orderedPackages = orderedPackages;
        this.totalWeight = 0.0;
        this.actualTotalWeight = packageWeight * orderedPackages;
        this.finished = finished;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public double getPackageWeight() {
        return this.packageWeight;
    }

    public void setPackageWeight(double packageWeight) {
        this.packageWeight = packageWeight;
    }

    public double getOrderedPackages() {
        return this.orderedPackages;
    }

    public void setOrderedPackages(double orderedPackages) {
        this.orderedPackages = orderedPackages;
    }

    public double getResultingPackages() {
        return this.totalWeight / this.packageWeight;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(double totalWeight) {
        this.totalWeight = totalWeight;
    }

    public double getActualTotalWeight() {
        return this.actualTotalWeight;
    }

    public void setActualTotalWeight(double actualTotalWeight) {
        this.actualTotalWeight = actualTotalWeight;
    }

    public double getWeightCoverPercentage() {
        return this.totalWeight > 0.0 ? this.actualTotalWeight / this.totalWeight : -1.0;
    }

    public double getTotalAmount() {
        return this.orderedPackages * this.packageWeight * this.price;
    }

    public double getRemainingQta() {
        return this.actualTotalWeight - this.totalWeight;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

