/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.gastabien.model.SummaryBodyTableModel;

public class SingleUndoableEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private int rowIndex;
    private int colIndex;
    private String oldValue;
    private String newValue;
    private SummaryBodyTableModel tableModel;
    private static int increment = 0;
    private int id;

    public SingleUndoableEdit(int rowIndex, int colIndex, String oldValue, String newValue, SummaryBodyTableModel tableModel) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.tableModel = tableModel;
        this.id = increment++;
        System.out.println("undoable created (" + this.id + ")");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        System.out.println("redo (" + this.id + ")");
        this.tableModel.setValueAt(this.newValue, this.rowIndex, this.colIndex, false);
        this.tableModel.fireTableCellUpdated(this.rowIndex, this.colIndex);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        System.out.println("undo (" + this.id + ")");
        this.tableModel.setValueAt(this.oldValue, this.rowIndex, this.colIndex, false);
        this.tableModel.fireTableCellUpdated(this.rowIndex, this.colIndex);
    }
}

