/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gastabien.model.OrderItem;
import org.gastabien.model.User;
import org.gastabien.model.UserOrder;

public class SmistamentoModel {
    private String idDataOrdine;
    private Map<String, User> usersMap;
    private List<String> usersWithOrder;
    private List<UserOrder> orderList;
    private List<OrderItem> itemList;

    public String getIdDataOrdine() {
        return this.idDataOrdine;
    }

    public void setIdDataOrdine(String idDataOrdine) {
        this.idDataOrdine = idDataOrdine;
    }

    public Map<String, User> getUsersMap() {
        return this.usersMap;
    }

    public void setUsersMap(Map<String, User> usersMap) {
        this.usersMap = usersMap;
    }

    public List<String> getUsersWithOrder() {
        return this.usersWithOrder;
    }

    public void setUsersWithOrder(List<String> usersWithOrder) {
        this.usersWithOrder = usersWithOrder;
    }

    public UserOrder getUserOrder(int index) {
        return this.orderList.get(index);
    }

    public void addUserOrder(UserOrder userOrder) {
        this.orderList.add(userOrder);
    }

    public int getUserOrderCount() {
        return this.orderList.size();
    }

    public void setOrderList(List<UserOrder> orderList) {
        this.orderList = orderList;
    }

    public OrderItem getOrderItem(int index) {
        return this.itemList.get(index);
    }

    public int getOrderItemCount() {
        return this.itemList.size();
    }

    public void setItemList(List<OrderItem> itemList) {
        this.itemList = itemList;
    }

    public void saveOnFile(File outputFile) throws Exception {
        FileWriter fw = new FileWriter(outputFile, false);
        if (this.idDataOrdine != null) {
            fw.write("#ORDER=" + this.idDataOrdine + "\n");
        }
        String usersRow = "";
        for (User user : this.usersMap.values()) {
            usersRow = String.valueOf(usersRow) + user.getId() + "|" + user.getName() + "|" + user.getEmail() + "|" + user.getPhone() + ";";
        }
        if (usersRow.length() > 0) {
            usersRow = usersRow.substring(0, usersRow.length() - 1);
        }
        fw.write(String.valueOf(usersRow) + "\n");
        for (UserOrder order : this.orderList) {
            fw.write(";" + order.getUser().getId());
        }
        fw.write("\n");
        int i = 0;
        while (i < this.itemList.size()) {
            OrderItem item = this.itemList.get(i);
            fw.write(String.valueOf(item.getId()) + "|" + item.getDescription() + "|" + item.getPrice() + "|" + item.getUnit() + "|" + item.getPackageWeight() + "|" + item.getOrderedPackages() + "|" + item.isFinished());
            for (UserOrder order : this.orderList) {
                fw.write(";" + (order.getQuantity(item) != null ? order.getQuantity(item) : "") + "|" + (order.getOriginalQuantity(item) != null ? order.getOriginalQuantity(item) : ""));
            }
            fw.write("\n");
            ++i;
        }
        fw.close();
    }

    public static SmistamentoModel parseFile(File inputFile) throws Exception {
        SmistamentoModel result = new SmistamentoModel();
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        String line = br.readLine();
        if (line.startsWith("#ORDER=")) {
            String orderId = line.split("=")[1];
            result.setIdDataOrdine(orderId);
            line = br.readLine();
        }
        String[] userInfoList = line.split(";");
        HashMap<String, User> usersMap = new HashMap<String, User>();
        int i = 0;
        while (i < userInfoList.length) {
            String[] userAttributes = userInfoList[i].split("\\|", -1);
            System.out.println(userInfoList[i]);
            usersMap.put(userAttributes[0], new User(userAttributes[0], userAttributes[1], userAttributes[2], userAttributes[3]));
            ++i;
        }
        result.setUsersMap(usersMap);
        line = br.readLine();
        String[] userOrderList = line.split(";");
        ArrayList<UserOrder> orderList = new ArrayList<UserOrder>();
        ArrayList<String> usersWithOrder = new ArrayList<String>();
        int i2 = 1;
        while (i2 < userOrderList.length) {
            System.out.println(userOrderList[i2]);
            orderList.add(new UserOrder((User)usersMap.get(userOrderList[i2])));
            usersWithOrder.add(userOrderList[i2]);
            ++i2;
        }
        result.setOrderList(orderList);
        result.setUsersWithOrder(usersWithOrder);
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        line = br.readLine();
        while (line != null) {
            String[] itemQuantities = line.split(";");
            String[] itemAttributes = itemQuantities[0].split("\\|");
            System.out.println(itemQuantities[0]);
            OrderItem currItem = new OrderItem(itemAttributes[0], itemAttributes[1], Double.parseDouble(itemAttributes[2]), itemAttributes[3], Double.parseDouble(itemAttributes[4]), Double.parseDouble(itemAttributes[5]), itemAttributes.length > 6 && Boolean.parseBoolean(itemAttributes[6]));
            itemList.add(currItem);
            double totalWeight = 0.0;
            int i3 = 1;
            while (i3 < itemQuantities.length) {
                String[] quantityTokens = itemQuantities[i3].split("\\|", -1);
                if (quantityTokens[0].length() > 0) {
                    double qta = Double.parseDouble(quantityTokens[0]);
                    ((UserOrder)orderList.get(i3 - 1)).setQuantity(currItem, qta);
                    totalWeight += qta;
                }
                if (quantityTokens[1].length() > 0) {
                    double qtaOriginale = Double.parseDouble(quantityTokens[1]);
                    ((UserOrder)orderList.get(i3 - 1)).setOriginalQuantity(currItem, qtaOriginale);
                }
                ++i3;
            }
            currItem.setTotalWeight(totalWeight);
            line = br.readLine();
        }
        result.setItemList(itemList);
        return result;
    }

    public void mergeFile(File inputFile) throws Exception {
        SmistamentoModel otherModel = SmistamentoModel.parseFile(inputFile);
        HashMap<String, OrderItem> thisItemsMap = new HashMap<String, OrderItem>();
        for (OrderItem item : this.itemList) {
            thisItemsMap.put(item.getId(), item);
        }
        for (OrderItem item : otherModel.itemList) {
            if (!thisItemsMap.containsKey(item.getId())) {
                throw new Exception("Il prodotto " + item.getDescription() + " non esiste nel file di destinazione, l'unione viene annullata, nessuna modifica \u00e8 stata effettuata.");
            }
            if (!item.isFinished() || !((OrderItem)thisItemsMap.get(item.getId())).isFinished()) continue;
            throw new Exception("Il prodotto " + item.getDescription() + " \u00e8 segnato come completato in entrambi i file, l'unione viene annullata, nessuna modifica \u00e8 stata effettuata.");
        }
        Map<String, UserOrder> thisOrderMap = this.getUserOrderMap(this.orderList);
        Map<String, UserOrder> otherOrderMap = this.getUserOrderMap(otherModel.orderList);
        for (OrderItem otherItem : otherModel.itemList) {
            if (!otherItem.isFinished()) continue;
            OrderItem thisItem = (OrderItem)thisItemsMap.get(otherItem.getId());
            thisItem.setOrderedPackages(otherItem.getOrderedPackages());
            thisItem.setPackageWeight(otherItem.getPackageWeight());
            thisItem.setPrice(otherItem.getPrice());
            thisItem.setActualTotalWeight(otherItem.getActualTotalWeight());
            thisItem.setFinished(true);
            this.mergeOrderItem(thisItem, otherItem, thisOrderMap, otherOrderMap);
            this.updateTotalWeight(thisItem);
        }
    }

    private Map<String, UserOrder> getUserOrderMap(List<UserOrder> userOrderlist) {
        HashMap<String, UserOrder> orderMap = new HashMap<String, UserOrder>();
        for (UserOrder order : userOrderlist) {
            orderMap.put(order.getUser().getId(), order);
        }
        return orderMap;
    }

    private void mergeOrderItem(OrderItem thisItem, OrderItem otherItem, Map<String, UserOrder> thisOrderMap, Map<String, UserOrder> otherOrderMap) {
        for (String userId : this.usersMap.keySet()) {
            if (otherOrderMap.containsKey(userId)) {
                UserOrder otherUserOrder = otherOrderMap.get(userId);
                UserOrder thisUserOrder = thisOrderMap.get(userId);
                if (thisUserOrder == null) {
                    thisUserOrder = new UserOrder(this.usersMap.get(userId));
                    this.orderList.add(thisUserOrder);
                    thisOrderMap.put(userId, thisUserOrder);
                    this.usersWithOrder.add(userId);
                }
                thisUserOrder.setQuantity(thisItem, otherUserOrder.getQuantity(otherItem));
                thisUserOrder.setOriginalQuantity(thisItem, otherUserOrder.getOriginalQuantity(otherItem));
                continue;
            }
            UserOrder thisUserOrder = thisOrderMap.get(userId);
            if (thisUserOrder == null) continue;
            thisUserOrder.setQuantity(thisItem, null);
            thisUserOrder.setOriginalQuantity(thisItem, null);
        }
    }

    public void updateTotalWeight(int orderItemIndex) {
        this.updateTotalWeight(this.itemList.get(orderItemIndex));
    }

    public void updateTotalWeight(OrderItem orderItem) {
        double totalProductQta = 0.0;
        for (UserOrder order : this.orderList) {
            Double qta = order.getQuantity(orderItem);
            if (qta == null) continue;
            totalProductQta += qta.doubleValue();
        }
        orderItem.setTotalWeight(totalProductQta);
    }

    public double getTotalOrdered() {
        double orderTotalOrdered = 0.0;
        for (OrderItem order : this.itemList) {
            orderTotalOrdered += order.getTotalAmount();
        }
        return orderTotalOrdered;
    }

    public double getTotalDispatched() {
        double orderTotalDispatched = 0.0;
        for (UserOrder order : this.orderList) {
            orderTotalDispatched += order.getOrderTotal();
        }
        return orderTotalDispatched;
    }
}

