/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.UndoManager;
import org.gastabien.model.MultipleUndoableEdit;
import org.gastabien.model.OrderItem;
import org.gastabien.model.SingleUndoableEdit;
import org.gastabien.model.SmistamentoModel;
import org.gastabien.model.UserOrder;

public class SummaryBodyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private static final DecimalFormat currencyDecimalFormat = new DecimalFormat("0.00 \u20ac");
    private SmistamentoModel smistamentoModel;
    private AbstractTableModel headerTableModel;
    private AbstractTableModel footerTableModel;
    private JLabel totalLabel;
    private UndoManager undoManager;

    public SummaryBodyTableModel(SmistamentoModel smistamentoModel, UndoManager undoManager) {
        this.smistamentoModel = smistamentoModel;
        this.undoManager = undoManager;
    }

    @Override
    public String getColumnName(int column) {
        return "<html><center><b>" + (column + 1) + "</b><br>" + this.smistamentoModel.getUserOrder(column).getUser().getName().replaceFirst(" ", "<br>") + "<center></html>";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.smistamentoModel.getUserOrder(columnIndex).isFinished() && !this.smistamentoModel.getOrderItem(rowIndex).isFinished();
    }

    @Override
    public int getColumnCount() {
        return this.smistamentoModel.getUserOrderCount();
    }

    @Override
    public int getRowCount() {
        return this.smistamentoModel.getOrderItemCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OrderItem product = this.smistamentoModel.getOrderItem(rowIndex);
        Double quantity = this.smistamentoModel.getUserOrder(columnIndex).getQuantity(product);
        if (quantity != null) {
            return decimalFormat.format(quantity);
        }
        return quantity;
    }

    public Object getOriginalValueAt(int rowIndex, int columnIndex) {
        Double quantity = this.smistamentoModel.getUserOrder(columnIndex).getOriginalQuantity(this.smistamentoModel.getOrderItem(rowIndex));
        if (quantity != null) {
            return decimalFormat.format(quantity);
        }
        return quantity;
    }

    public int getPackages(int rowIndex, int columnIndex) {
        int packages = 0;
        OrderItem product = this.smistamentoModel.getOrderItem(rowIndex);
        Double quantity = this.smistamentoModel.getUserOrder(columnIndex).getQuantity(product);
        if (quantity != null && quantity > 0.0 && product.getPackageWeight() > 1.0 && quantity % product.getPackageWeight() == 0.0) {
            packages = (int)(quantity / product.getPackageWeight());
        }
        return packages;
    }

    public boolean valueChanged(int rowIndex, int columnIndex) {
        double originalQty;
        Double quantity = this.smistamentoModel.getUserOrder(columnIndex).getQuantity(this.smistamentoModel.getOrderItem(rowIndex));
        Double originalQuantity = this.smistamentoModel.getUserOrder(columnIndex).getOriginalQuantity(this.smistamentoModel.getOrderItem(rowIndex));
        double qty = quantity == null ? 0.0 : quantity;
        double d = originalQty = originalQuantity == null ? 0.0 : originalQuantity;
        return qty != originalQty;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean undoable) {
        try {
            String newValueStr;
            String strValue = (String)aValue;
            Double newValue = null;
            if (strValue.length() > 0) {
                newValue = decimalFormat.parse(strValue).doubleValue();
            }
            Double oldValue = this.smistamentoModel.getUserOrder(columnIndex).getQuantity(this.smistamentoModel.getOrderItem(rowIndex));
            this.smistamentoModel.getUserOrder(columnIndex).setQuantity(this.smistamentoModel.getOrderItem(rowIndex), newValue);
            this.smistamentoModel.updateTotalWeight(rowIndex);
            String oldValueStr = oldValue == null ? "" : decimalFormat.format(oldValue);
            String string = newValueStr = newValue == null ? "" : decimalFormat.format(newValue);
            if (undoable && !oldValueStr.equals(newValueStr)) {
                this.undoManager.addEdit(new SingleUndoableEdit(rowIndex, columnIndex, oldValueStr, strValue, this));
            }
            if (this.footerTableModel != null) {
                this.footerTableModel.fireTableCellUpdated(0, columnIndex);
            }
            this.updateExternalSections(rowIndex);
        }
        catch (ParseException e) {
            System.out.println("Il valore deve essere numerico");
        }
    }

    public void distributeItemQty(int row) {
        OrderItem item = this.smistamentoModel.getOrderItem(row);
        MultipleUndoableEdit undoableItem = new MultipleUndoableEdit(this);
        double remainingWeight = item.getActualTotalWeight() - item.getTotalWeight();
        double newTotalWeight = 0.0;
        int i = 0;
        while (i < this.smistamentoModel.getUserOrderCount()) {
            UserOrder order = this.smistamentoModel.getUserOrder(i);
            Double oldQty = order.getQuantity(item);
            if (oldQty != null) {
                double newQty = oldQty + remainingWeight / item.getTotalWeight() * oldQty;
                order.setQuantity(item, newQty);
                undoableItem.addCell(row, i, decimalFormat.format(oldQty), decimalFormat.format(newQty));
                newTotalWeight += newQty;
            }
            ++i;
        }
        item.setTotalWeight(newTotalWeight);
        this.fireTableRowsUpdated(row, row);
        if (this.footerTableModel != null) {
            this.footerTableModel.fireTableDataChanged();
        }
        this.updateExternalSections(row);
    }

    private void updateExternalSections(int rowIndex) {
        if (this.headerTableModel != null) {
            this.headerTableModel.fireTableRowsUpdated(rowIndex, rowIndex);
        }
        this.totalLabel.setText("Totale smistamento: " + currencyDecimalFormat.format(this.smistamentoModel.getTotalDispatched()));
    }

    public void setExternalTableModel(AbstractTableModel headerTableModel, AbstractTableModel footerTableModel) {
        this.headerTableModel = headerTableModel;
        this.footerTableModel = footerTableModel;
    }

    public void setTotalLabel(JLabel label) {
        this.totalLabel = label;
    }
}

