/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gastabien.model.SmistamentoModel;
import org.gastabien.model.SummaryBodyTableModel;
import org.gastabien.util.Preferences;

public class SummaryHeaderTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Descrizione", "Costo", "UM", "Peso Collo", "Colli Ord.", "Colli Ris.", "Peso totale", "Peso reale", "Coper tura", "Rima nenze"};
    public static final String[] MENU_COLUMN_NAMES = new String[]{"Descrizione", "Costo", "Unit\u00e0 di Misura", "Peso Collo", "Colli Ordinati", "Colli Risultanti", "Peso totale smistato", "Peso reale", "Copertura smistato", "Rimanenze"};
    private static final DecimalFormat decimalFormatCurrency = new DecimalFormat("0.00 \u20ac");
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private static final DecimalFormat percentageFormat = new DecimalFormat("0%");
    private SmistamentoModel smistamentoModel;
    private SummaryBodyTableModel summaryBodyTableModel;
    private Preferences preferences;
    private JLabel totalLabel;
    private boolean[] columnVisible = new boolean[7];
    private TableColumnModel columnModel;
    private List<TableColumn> dynamicColumns;
    private JSplitPane splitPane;

    public SummaryHeaderTableModel(SmistamentoModel smistamentoModel, Preferences preferences) {
        this.smistamentoModel = smistamentoModel;
        this.preferences = preferences;
        Arrays.fill(this.columnVisible, false);
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.dynamicColumns = new ArrayList<TableColumn>();
        int i = 0;
        while (i < 10) {
            TableColumn col = columnModel.getColumn(i);
            if (i > 2) {
                this.dynamicColumns.add(col);
            }
            if (i > 0) {
                col.setMinWidth(50);
                col.setMaxWidth(50);
            }
            ++i;
        }
        this.updateVisibleColumns();
    }

    @Override
    public String getColumnName(int column) {
        return "<html><center>" + COLUMN_NAMES[column].replaceFirst(" ", "<br>") + "<center></html>";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3 || columnIndex == 4 || columnIndex == 7;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            switch (columnIndex) {
                case 3: {
                    this.smistamentoModel.getOrderItem(rowIndex).setPackageWeight(decimalFormat.parse((String)aValue).doubleValue());
                    break;
                }
                case 4: {
                    this.smistamentoModel.getOrderItem(rowIndex).setOrderedPackages(decimalFormat.parse((String)aValue).doubleValue());
                    break;
                }
                case 7: {
                    double oldValue = this.smistamentoModel.getOrderItem(rowIndex).getActualTotalWeight();
                    double newValue = decimalFormat.parse((String)aValue).doubleValue();
                    this.smistamentoModel.getOrderItem(rowIndex).setActualTotalWeight(newValue);
                    if (!this.preferences.isAutomaticallyDistributeQty() || oldValue == newValue) break;
                    System.out.println("Distributing quantity fo row " + rowIndex);
                    this.summaryBodyTableModel.distributeItemQty(rowIndex);
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
            this.totalLabel.setText("Totale ordinato:           " + decimalFormatCurrency.format(this.smistamentoModel.getTotalOrdered()));
        }
        catch (ParseException e) {
            System.out.println("Il valore deve essere numerico");
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.smistamentoModel.getOrderItemCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.smistamentoModel.getOrderItem(rowIndex).getDescription();
            }
            case 1: {
                return decimalFormatCurrency.format(this.smistamentoModel.getOrderItem(rowIndex).getPrice());
            }
            case 2: {
                return this.smistamentoModel.getOrderItem(rowIndex).getUnit();
            }
            case 3: {
                return decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getPackageWeight());
            }
            case 4: {
                return decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getOrderedPackages());
            }
            case 5: {
                return decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getResultingPackages());
            }
            case 6: {
                return decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getTotalWeight());
            }
            case 7: {
                return decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getActualTotalWeight());
            }
            case 8: {
                double percentage = this.smistamentoModel.getOrderItem(rowIndex).getWeightCoverPercentage();
                return percentage < 0.0 ? "-" : percentageFormat.format(percentage);
            }
            case 9: {
                return this.smistamentoModel.getOrderItem(rowIndex).getRemainingQta() != 0.0 ? decimalFormat.format(this.smistamentoModel.getOrderItem(rowIndex).getRemainingQta()) : "";
            }
        }
        return null;
    }

    public void setTotalLabel(JLabel label) {
        this.totalLabel = label;
    }

    public void setSummaryBodyTableModel(SummaryBodyTableModel summaryBodyTableModel) {
        this.summaryBodyTableModel = summaryBodyTableModel;
    }

    public void setColumnVisible(int columnIndex, boolean visible, boolean triggerUpdate) {
        this.columnVisible[columnIndex] = visible;
        if (triggerUpdate) {
            this.updateVisibleColumns();
        }
    }

    public void setSplitPane(JSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    private void updateVisibleColumns() {
        int currentDividerLocation = 0;
        if (this.splitPane != null) {
            currentDividerLocation = this.splitPane.getDividerLocation() - (this.columnModel.getColumnCount() - 3) * 50;
        }
        int i = 0;
        while (i < this.columnVisible.length) {
            this.columnModel.removeColumn(this.dynamicColumns.get(i));
            ++i;
        }
        i = 0;
        while (i < this.columnVisible.length) {
            if (this.columnVisible[i]) {
                this.columnModel.addColumn(this.dynamicColumns.get(i));
            }
            ++i;
        }
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(currentDividerLocation + (this.columnModel.getColumnCount() - 3) * 50);
        }
    }
}

