/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.model;

import java.util.HashMap;
import java.util.Map;
import org.gastabien.model.OrderItem;
import org.gastabien.model.User;

public class UserOrder {
    private User user;
    private Map<OrderItem, Double> orderDetail;
    private Map<OrderItem, Double> originalOrder;
    private double orderTotal;
    private boolean finished;

    public UserOrder(User user) {
        this.user = user;
        this.orderDetail = new HashMap<OrderItem, Double>();
        this.originalOrder = new HashMap<OrderItem, Double>();
        this.orderTotal = 0.0;
        this.finished = false;
    }

    public double getOrderTotal() {
        return this.orderTotal;
    }

    public User getUser() {
        return this.user;
    }

    public Map<OrderItem, Double> getOrderDetail() {
        return this.orderDetail;
    }

    public Double getQuantity(OrderItem item) {
        return this.orderDetail.get(item);
    }

    public Double getOriginalQuantity(OrderItem item) {
        return this.originalOrder.get(item);
    }

    public void setQuantity(OrderItem item, Double value) {
        if (value == null) {
            this.orderDetail.remove(item);
        } else {
            this.orderDetail.put(item, value);
        }
        this.calculateTotal();
    }

    public void setOriginalQuantity(OrderItem item, Double value) {
        if (value == null) {
            this.originalOrder.remove(item);
        } else {
            this.originalOrder.put(item, value);
        }
    }

    private void calculateTotal() {
        this.orderTotal = 0.0;
        for (Map.Entry<OrderItem, Double> orderDetailEntry : this.orderDetail.entrySet()) {
            this.orderTotal += orderDetailEntry.getKey().getPrice() * orderDetailEntry.getValue();
        }
        this.orderTotal = (double)Math.round(this.orderTotal * 100.0) / 100.0;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

