/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.gastabien.exception.ConnectionException;
import org.gastabien.model.OrderModelItem;
import org.gastabien.util.FileUtil;
import org.gastabien.util.Preferences;

public class RemoteConnection {
    private static final String CHIUSO = "1";
    private Preferences preferences;
    private JsonParser parser;

    public RemoteConnection(Preferences preferences) {
        this.preferences = preferences;
        this.parser = new JsonParser();
    }

    public List<OrderModelItem> getOrderTypes() throws ConnectionException, ClientProtocolException, IOException, Exception {
        CloseableHttpResponse response = this.connect(String.valueOf(this.preferences.getGoGasBaseUrl()) + "/Smistamento/TipiOrdine", this.preferences.getGoGasUsername(), this.preferences.getGoGasPassword(), null);
        JsonReader reader = new JsonReader(new InputStreamReader(response.getEntity().getContent()));
        JsonElement jsonst = this.parser.parse(reader);
        reader.close();
        response.close();
        JsonObject object = jsonst.getAsJsonObject();
        boolean error = object.get("error").getAsBoolean();
        if (error) {
            throw new Exception(String.valueOf(object.get("errorType").getAsString()) + " " + object.get("errorMessage").getAsString());
        }
        ArrayList<OrderModelItem> orderDateList = new ArrayList<OrderModelItem>();
        JsonArray array = object.get("data").getAsJsonArray();
        int i = 0;
        while (i < array.size()) {
            JsonObject record = array.get(i).getAsJsonObject();
            orderDateList.add(new OrderModelItem(record.get("id").getAsString(), record.get("descrizione").getAsString()));
            ++i;
        }
        return orderDateList;
    }

    public List<OrderModelItem> getOrders(String orderTypeId) throws ConnectionException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FiltroTipologia", orderTypeId);
        params.put("FiltroStato", CHIUSO);
        CloseableHttpResponse response = this.connect(String.valueOf(this.preferences.getGoGasBaseUrl()) + "/Smistamento/ListaOrdini", this.preferences.getGoGasUsername(), this.preferences.getGoGasPassword(), params);
        JsonReader reader = new JsonReader(new InputStreamReader(response.getEntity().getContent()));
        JsonElement jsonst = this.parser.parse(reader);
        reader.close();
        response.close();
        JsonObject object = jsonst.getAsJsonObject();
        boolean error = object.get("error").getAsBoolean();
        if (error) {
            throw new Exception(String.valueOf(object.get("errorType").getAsString()) + " " + object.get("errorMessage").getAsString());
        }
        ArrayList<OrderModelItem> orderDateList = new ArrayList<OrderModelItem>();
        JsonArray array = object.get("data").getAsJsonArray();
        int i = 0;
        while (i < array.size()) {
            JsonObject record = array.get(i).getAsJsonObject();
            orderDateList.add(new OrderModelItem(record.get("id").getAsString(), record.get("dataconsegna").getAsString()));
            ++i;
        }
        return orderDateList;
    }

    public File getOrder(String orderId) throws ConnectionException, Exception {
        int option;
        File outputDir = new File("downloads");
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("idDataOrdine", orderId);
        CloseableHttpResponse response = this.connect(String.valueOf(this.preferences.getGoGasBaseUrl()) + "/Smistamento/ExportFileSmistamento", this.preferences.getGoGasUsername(), this.preferences.getGoGasPassword(), params);
        Header contentDispositionHeader = response.getFirstHeader("content-disposition");
        String fileName = contentDispositionHeader.getValue().split("=")[1];
        File outputFile = new File(String.valueOf(outputDir.getAbsolutePath()) + File.separator + fileName);
        if (outputFile.exists() && ((option = JOptionPane.showConfirmDialog(null, "Attenzione, il file " + outputFile.getAbsolutePath() + " esiste gi\u00e0. Sovrascrivere?", "File esistente", 2, 2)) == -1 || option == 2)) {
            return null;
        }
        FileOutputStream out = new FileOutputStream(outputFile);
        FileUtil.copyStream(response.getEntity().getContent(), (OutputStream)out, true);
        out.close();
        response.close();
        return outputFile;
    }

    public boolean sendOrder(String orderId, File orderFile) throws ConnectionException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("idDataOrdine", orderId);
        CloseableHttpResponse response = this.connect(String.valueOf(this.preferences.getGoGasBaseUrl()) + "/Smistamento/UpdateOrderFromFile", this.preferences.getGoGasUsername(), this.preferences.getGoGasPassword(), params, orderFile);
        JsonReader reader = new JsonReader(new InputStreamReader(response.getEntity().getContent()));
        JsonElement jsonst = this.parser.parse(reader);
        reader.close();
        response.close();
        JsonObject object = jsonst.getAsJsonObject();
        boolean error = object.get("error").getAsBoolean();
        if (error) {
            throw new Exception(String.valueOf(object.get("errorType").getAsString()) + " " + object.get("errorMessage").getAsString());
        }
        return "OK".equals(object.get("data").getAsString());
    }

    private CloseableHttpResponse connect(String url, String username, String password, Map<String, String> params) throws ConnectionException, ClientProtocolException, IOException {
        return this.connect(url, username, password, params, null);
    }

    private CloseableHttpResponse connect(String url, String username, String password, Map<String, String> params, File file) throws ConnectionException, ClientProtocolException, IOException {
        if (url == null || url.length() == 0 || username == null || username.length() == 0 || password == null || password.length() == 0) {
            throw new ConnectionException(0, "Empty params");
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("username", username);
        params.put("password", password);
        HttpEntity entity = null;
        entity = file != null ? this.getMultipartEntity(params, file) : this.getSimpleEntity(params);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        CloseableHttpResponse response = httpclient.execute(httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            switch (response.getStatusLine().getStatusCode()) {
                case 403: {
                    throw new ConnectionException(403, "Credenziali non valide o utente non autorizzato");
                }
            }
            throw new ConnectionException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    private HttpEntity getSimpleEntity(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                postParams.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
        }
        return new UrlEncodedFormEntity(postParams, "UTF-8");
    }

    private HttpEntity getMultipartEntity(Map<String, String> params, File file) throws UnsupportedEncodingException, IOException, FileNotFoundException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                builder.addPart(param.getKey(), new StringBody(param.getValue(), ContentType.MULTIPART_FORM_DATA));
            }
        }
        FileInputStream fis = new FileInputStream(file);
        String md5String = DigestUtils.md5Hex(fis);
        fis.close();
        builder.addPart("md5", new StringBody(md5String, ContentType.MULTIPART_FORM_DATA));
        if (file != null) {
            builder.addPart("uploadedFile", new FileBody(file));
        }
        return builder.build();
    }
}

