/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.gastabien.util.Preferences;
import org.gastabien.util.SpringUtilities;

public class ConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Preferences preferences;
    private JTextField url;
    private JTextField username;
    private JTextField password;
    private JLabel connectionNotification;

    public ConnectionPanel(Preferences preferences) {
        super(new BorderLayout());
        this.preferences = preferences;
        this.draw();
    }

    private void draw() {
        JPanel centralPanel = new JPanel(new SpringLayout());
        JLabel addressLabel = new JLabel("Indirizzo del sito");
        addressLabel.setToolTipText("Indirizzo di base di Go!Gas (ad esempio: http://nomegas.aequos.eu)");
        centralPanel.add(addressLabel);
        this.url = new JTextField(this.preferences.getGoGasBaseUrl(), 30);
        this.url.setToolTipText("Indirizzo di base di Go!Gas (ad esempio: http://nomegas.aequos.eu)");
        centralPanel.add(this.url);
        centralPanel.add(new JLabel("Username"));
        this.username = new JTextField(this.preferences.getGoGasUsername(), 30);
        centralPanel.add(this.username);
        centralPanel.add(new JLabel("Password"));
        this.password = new JPasswordField(this.preferences.getGoGasPassword(), 30);
        centralPanel.add(this.password);
        SpringUtilities.makeCompactGrid(centralPanel, 3, 2, 10, 10, 10, 10);
        this.add((Component)centralPanel, "Center");
        this.connectionNotification = new JLabel();
        this.connectionNotification.setForeground(Color.RED);
        this.add((Component)this.connectionNotification, "North");
    }

    public boolean getConnectionParams(String errorMessage, String confirmText) {
        int messageType = -1;
        String title = "Inserisci parametri di connessione a Go!Gas";
        if (errorMessage != null) {
            this.connectionNotification.setText("ERRORE - " + errorMessage);
            messageType = 0;
            title = "Errore durante la connessione a Go!Gas";
        }
        int option = JOptionPane.showOptionDialog(null, this, title, 1, messageType, null, new String[]{confirmText, "Annulla"}, confirmText);
        this.connectionNotification.setText("");
        if (option == -1 || option == 1) {
            return true;
        }
        this.preferences.setGoGasBaseUrl(this.url.getText());
        this.preferences.setGoGasUsername(this.username.getText());
        this.preferences.setGoGasPassword(this.password.getText());
        return false;
    }
}

