/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;
import org.gastabien.model.OrderListModel;
import org.gastabien.model.OrderModelItem;
import org.gastabien.task.RemoteConnection;
import org.gastabien.ui.ConnectionPanel;
import org.gastabien.ui.Smistamento;
import org.gastabien.util.Preferences;
import org.gastabien.util.SpringUtilities;

public class DownloadDialog
extends JDialog
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private Smistamento smistamento;
    private JList orderList;
    private JComboBox orderType;
    private JLabel notification;
    private Preferences preferences;
    private RemoteConnection remoteConnection;
    private JDialog waitDialog;
    private ConnectionPanel connectionPanel;
    private Action closeAction = new AbstractAction("Annulla"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DownloadDialog.this.dispose();
        }
    };
    private Action downloadAction = new AbstractAction("Apri"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final OrderModelItem selectedItem = (OrderModelItem)DownloadDialog.this.orderList.getSelectedValue();
            if (selectedItem == null) {
                return;
            }
            new SwingWorker<File, Void>(){

                @Override
                protected File doInBackground() throws Exception {
                    while (true) {
                        try {
                            return DownloadDialog.this.remoteConnection.getOrder(selectedItem.getId());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (!DownloadDialog.this.connectionPanel.getConnectionParams(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage(), "Riprova")) continue;
                            return null;
                        }
                        break;
                    }
                }

                @Override
                protected void done() {
                    try {
                        try {
                            File result = (File)this.get();
                            if (result != null) {
                                DownloadDialog.this.dispose();
                                DownloadDialog.this.smistamento.openFile(result);
                                DownloadDialog.this.preferences.setLastOpenedDir(result.getParentFile());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(null, "Errore durante l'elaborazione: " + e.getClass().getSimpleName() + " - " + e.getMessage(), "Errore", 0);
                            DownloadDialog.this.waitDialog.setVisible(false);
                        }
                    }
                    finally {
                        DownloadDialog.this.waitDialog.setVisible(false);
                    }
                }
            }.execute();
            DownloadDialog.this.waitDialog.setVisible(true);
        }
    };

    public DownloadDialog(JFrame owner, Preferences preferences) {
        super(owner, "Caricamento del file da Go!Gas", true);
        this.preferences = preferences;
        this.smistamento = (Smistamento)owner;
        this.remoteConnection = new RemoteConnection(preferences);
        this.connectionPanel = new ConnectionPanel(preferences);
        this.waitDialog = this.createWaitDialog();
    }

    private JDialog createWaitDialog() {
        JDialog dialog = new JDialog((Dialog)this, true);
        JLabel label = new JLabel("Connessione a Go!Gas in corso...");
        label.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Attendere");
        dialog.add(label);
        dialog.pack();
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    public void showOrderSelection() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel topPanel = new JPanel(new SpringLayout());
        topPanel.add(new JLabel("Tipo ordine:"));
        this.orderType = new JComboBox();
        this.orderType.addItemListener(this);
        topPanel.add(this.orderType);
        JLabel consegnaLabel = new JLabel("Data consegna:");
        consegnaLabel.setVerticalAlignment(1);
        topPanel.add(consegnaLabel);
        this.orderList = new JList(new OrderListModel(new ArrayList<OrderModelItem>()));
        JScrollPane listScrollPane = new JScrollPane(this.orderList);
        topPanel.add(listScrollPane);
        SpringUtilities.makeCompactGrid(topPanel, 2, 2, 10, 10, 10, 10);
        mainPanel.add((Component)topPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton connectButton = new JButton(this.downloadAction);
        connectButton.setMargin(new Insets(2, 2, 2, 2));
        buttonPanel.add(connectButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 20)));
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setMargin(new Insets(2, 2, 2, 2));
        buttonPanel.add(closeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        mainPanel.add((Component)buttonPanel, "South");
        this.add((Component)mainPanel, "Center");
        this.notification = new JLabel();
        this.add((Component)this.notification, "South");
        this.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.setLocation(screenWidth / 2 - this.getWidth() / 2, screenHeight / 2 - this.getHeight() / 2);
        this.setDefaultCloseOperation(2);
        this.loadOrderTypes();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        final OrderModelItem item = (OrderModelItem)e.getItem();
        if (item.getId() == null) {
            this.orderList.setModel(new OrderListModel(new ArrayList<OrderModelItem>()));
        } else {
            new SwingWorker<List<OrderModelItem>, Void>(){

                @Override
                protected List<OrderModelItem> doInBackground() throws Exception {
                    while (true) {
                        try {
                            return DownloadDialog.this.remoteConnection.getOrders(item.getId());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (!DownloadDialog.this.connectionPanel.getConnectionParams(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage(), "Riprova")) continue;
                            return new ArrayList<OrderModelItem>();
                        }
                        break;
                    }
                }

                @Override
                protected void done() {
                    try {
                        try {
                            DownloadDialog.this.orderList.setModel(new OrderListModel((List)this.get()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(null, "Errore durante l'elaborazione: " + e.getClass().getSimpleName() + " - " + e.getMessage(), "Errore", 0);
                            DownloadDialog.this.orderList.setModel(new OrderListModel(new ArrayList<OrderModelItem>()));
                            DownloadDialog.this.orderList.repaint();
                            DownloadDialog.this.waitDialog.setVisible(false);
                        }
                    }
                    finally {
                        DownloadDialog.this.orderList.repaint();
                        DownloadDialog.this.waitDialog.setVisible(false);
                    }
                }
            }.execute();
            this.waitDialog.setVisible(true);
        }
    }

    private void loadOrderTypes() {
        new SwingWorker<List<OrderModelItem>, Void>(){

            @Override
            protected List<OrderModelItem> doInBackground() throws Exception {
                while (true) {
                    try {
                        return DownloadDialog.this.remoteConnection.getOrderTypes();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (!DownloadDialog.this.connectionPanel.getConnectionParams(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage(), "Riprova")) continue;
                        return null;
                    }
                    break;
                }
            }

            @Override
            protected void done() {
                try {
                    try {
                        List result = (List)this.get();
                        if (result != null) {
                            DownloadDialog.this.orderType.removeAllItems();
                            DownloadDialog.this.orderType.addItem(new OrderModelItem(null, "Selezionare una tipologia..."));
                            for (OrderModelItem item : result) {
                                DownloadDialog.this.orderType.addItem(item);
                            }
                            DownloadDialog.this.waitDialog.setVisible(false);
                            DownloadDialog.this.setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Errore durante l'elaborazione: " + e.getClass().getSimpleName() + " - " + e.getMessage(), "Errore", 0);
                        DownloadDialog.this.waitDialog.setVisible(false);
                    }
                }
                finally {
                    DownloadDialog.this.waitDialog.setVisible(false);
                }
            }
        }.execute();
        this.waitDialog.setVisible(true);
    }

    public void sendOrder(final String idDataOrdine, final File currentFile) {
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                while (true) {
                    try {
                        return DownloadDialog.this.remoteConnection.sendOrder(idDataOrdine, currentFile);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (!DownloadDialog.this.connectionPanel.getConnectionParams(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage(), "Riprova")) continue;
                        return null;
                    }
                    break;
                }
            }

            @Override
            protected void done() {
                try {
                    try {
                        Boolean result = (Boolean)this.get();
                        DownloadDialog.this.waitDialog.setVisible(false);
                        if (result != null && result.booleanValue()) {
                            JOptionPane.showMessageDialog(null, "Quantit\u00e0 aggiornate con successo", "Aggiornamento quantit\u00e0 su Go!Gas", 1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Errore durante l'elaborazione: " + e.getClass().getSimpleName() + " - " + e.getMessage(), "Errore", 0);
                        DownloadDialog.this.waitDialog.setVisible(false);
                    }
                }
                finally {
                    DownloadDialog.this.waitDialog.setVisible(false);
                }
            }
        }.execute();
        this.waitDialog.setVisible(true);
    }
}

