/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import org.gastabien.model.OrderItem;
import org.gastabien.model.SmistamentoModel;
import org.gastabien.model.SummaryBodyTableModel;
import org.gastabien.model.SummaryFooterTableModel;
import org.gastabien.model.SummaryHeaderTableModel;
import org.gastabien.model.User;
import org.gastabien.model.UserOrder;
import org.gastabien.ui.ConnectionPanel;
import org.gastabien.ui.DigitKeyListener;
import org.gastabien.ui.DownloadDialog;
import org.gastabien.ui.OverwriteJTextField;
import org.gastabien.ui.PackableTable;
import org.gastabien.ui.RepaintSelectionListener;
import org.gastabien.ui.ShowColumnAction;
import org.gastabien.ui.SplitDividerListener;
import org.gastabien.ui.SummaryBodyTableCellRenderer;
import org.gastabien.ui.SummaryBodyTableHeaderRenderer;
import org.gastabien.ui.SummaryFooterTableCellRenderer;
import org.gastabien.ui.SummaryHeaderRepaintSelectionListener;
import org.gastabien.ui.SummaryHeaderTableCellRenderer;
import org.gastabien.ui.TableAdjustmentListener;
import org.gastabien.ui.TableTransferHandler;
import org.gastabien.ui.TransferActionListener;
import org.gastabien.util.FileUtil;
import org.gastabien.util.Preferences;

public class Smistamento
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "Gestione smistamento";
    private static final String FILE_EXTENSION = ".smi";
    private static final DecimalFormat currencyDecimalFormat = new DecimalFormat("0.00 \u20ac");
    private File currentFile = null;
    private UndoManager undoManager = new UndoManager();
    private static final String applicationVersion = "1.2.2";
    private static final String applicationReleaseDate = "21/04/2016";
    private FileFilter inputFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "File ordine per smistamento G.A.S.";
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(Smistamento.FILE_EXTENSION);
        }
    };
    private Action fileOpenAction = new AbstractAction("Apri da file"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser;
            int returnVal;
            if (Smistamento.this.currentFile != null) {
                Smistamento.this.closeAction.actionPerformed(e);
            }
            if ((returnVal = (fileChooser = Smistamento.this.createFileChooser(null)).showOpenDialog(null)) == 0) {
                try {
                    File file = fileChooser.getSelectedFile();
                    System.out.println("Opening: " + file.getName() + ".");
                    Smistamento.this.openFile(file);
                    Smistamento.this.preferences.setLastOpenedDir(file.getParentFile());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante l'apertura del file: " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore caricamento", 0);
                    e1.printStackTrace();
                }
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
    };
    private Action saveAsAction = new AbstractAction("Salva come..."){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = Smistamento.this.createFileChooser("Salva");
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                File file = fileChooser.getSelectedFile();
                if (!file.getName().endsWith(Smistamento.FILE_EXTENSION)) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + Smistamento.FILE_EXTENSION);
                }
                System.out.println("Saving: " + file.getName());
                try {
                    Smistamento.this.model.saveOnFile(file);
                    Smistamento.this.currentFile = file;
                    Smistamento.this.self.setTitle("Gestione smistamento - " + Smistamento.this.currentFile.getAbsolutePath());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante il salvataggio del file: " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore salvataggio", 0);
                    e1.printStackTrace();
                }
            } else {
                System.out.println("Save command cancelled by user.");
            }
        }
    };
    private Action saveAction = new AbstractAction("Salva"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Smistamento.this.model.saveOnFile(Smistamento.this.currentFile);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante il salvataggio del file: " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore salvataggio", 0);
                e1.printStackTrace();
            }
        }
    };
    private Action closeAction = new AbstractAction("Chiudi"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(null, "Salvare il file prima di chiuderlo?", "Chiusura file", 1);
            switch (result) {
                case 0: {
                    try {
                        Smistamento.this.model.saveOnFile(Smistamento.this.currentFile);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante il salvataggio su file: " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore salvataggio", 0);
                    }
                }
                case 1: {
                    Smistamento.this.self.getContentPane().removeAll();
                    Smistamento.this.self.setTitle(Smistamento.WINDOW_TITLE);
                    SwingUtilities.updateComponentTreeUI(Smistamento.this.self.getContentPane());
                    Smistamento.this.currentFile = null;
                    Smistamento.this.setEnabledFileActions(false);
                }
            }
        }
    };
    private Action mergeAction = new AbstractAction("Unisci"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = Smistamento.this.createFileChooser("Scegli");
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                String action = "";
                try {
                    File file = fileChooser.getSelectedFile();
                    int result = JOptionPane.showConfirmDialog(null, "Alcuni dati verranno sovrascritti, salvare il file prima di continuare?", "Unione file", 1);
                    switch (result) {
                        case 0: {
                            action = "il salvataggio del file";
                            Smistamento.this.model.saveOnFile(Smistamento.this.currentFile);
                        }
                        case 1: {
                            result = JOptionPane.showConfirmDialog(null, "Proseguendo verranno importati dal file selezionato i valori dei soli prodotti segnati come completati. Continuare?", "Unione file", 0);
                            if (result != 0) break;
                            System.out.println("Merging with: " + file.getName() + ".");
                            action = "l'unione dei file";
                            Smistamento.this.model.mergeFile(file);
                            ((SummaryBodyTableModel)Smistamento.this.summaryBodyTable.getModel()).fireTableStructureChanged();
                            ((SummaryFooterTableModel)Smistamento.this.footerTable.getModel()).fireTableStructureChanged();
                            SwingUtilities.updateComponentTreeUI(Smistamento.this.self.getContentPane());
                            Smistamento.this.preferences.setLastOpenedDir(file.getParentFile());
                        }
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante " + action + ": " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore caricamento", 0);
                    e1.printStackTrace();
                }
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
    };
    private Action exitAction = new AbstractAction("Esci"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Smistamento.this.exit();
        }
    };
    private Action versionAction = new AbstractAction("Versione"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Smistamento.this.self, "Versione: 1.2.2\nRilasciata il: 21/04/2016", "Versione", 1);
        }
    };
    private Action undoAction = new AbstractAction(this.undoManager.getUndoPresentationName()){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Smistamento.this.undoManager.canUndo()) {
                Smistamento.this.undoManager.undo();
            }
            System.out.println("CanUndo:" + Smistamento.this.undoManager.canUndo() + " - CanRedo:" + Smistamento.this.undoManager.canRedo());
            Smistamento.this.undoAction.setEnabled(Smistamento.this.undoManager.canUndo());
            Smistamento.this.redoAction.setEnabled(Smistamento.this.undoManager.canRedo());
        }
    };
    private Action redoAction = new AbstractAction(this.undoManager.getRedoPresentationName()){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Smistamento.this.undoManager.canRedo()) {
                Smistamento.this.undoManager.redo();
            }
            System.out.println("CanUndo:" + Smistamento.this.undoManager.canUndo() + " - CanRedo:" + Smistamento.this.undoManager.canRedo());
            Smistamento.this.undoAction.setEnabled(Smistamento.this.undoManager.canUndo());
            Smistamento.this.redoAction.setEnabled(Smistamento.this.undoManager.canRedo());
        }
    };
    private Action completeUserAction = new AbstractAction("Utente completato"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            int selectedColumn = Smistamento.this.summaryBodyTable.getSelectedColumn();
            if (selectedColumn > -1) {
                UserOrder order;
                order.setFinished(!(order = Smistamento.this.model.getUserOrder(selectedColumn)).isFinished());
                ((AbstractTableModel)Smistamento.this.footerTable.getModel()).fireTableCellUpdated(0, selectedColumn);
                ((AbstractTableModel)Smistamento.this.summaryBodyTable.getModel()).fireTableDataChanged();
                Smistamento.this.summaryBodyTable.getTableHeader().repaint();
            }
        }
    };
    private Action addNewUserAction = new AbstractAction("Aggiungi utente"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog newUserDialog = new JDialog(Smistamento.this.self, "Inserisci nuovo utente", true);
            newUserDialog.setLayout(new BorderLayout(2, 2));
            JLabel label = new JLabel("Utente:");
            newUserDialog.add((Component)label, "West");
            ArrayList<String> usersWithoutOrderList = new ArrayList<String>(Smistamento.this.model.getUsersMap().keySet());
            usersWithoutOrderList.removeAll(Smistamento.this.model.getUsersWithOrder());
            Vector<User> usersWithoutOrderVector = new Vector<User>();
            for (String user : usersWithoutOrderList) {
                usersWithoutOrderVector.add(Smistamento.this.model.getUsersMap().get(user));
            }
            Collections.sort(usersWithoutOrderVector);
            final JComboBox<Object> usersList = new JComboBox<Object>(usersWithoutOrderVector);
            usersList.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    c.setText(((User)value).getName());
                    return c;
                }
            });
            newUserDialog.add(usersList, "Center");
            JPanel buttonsPanel = new JPanel(new BorderLayout(2, 2));
            JButton ok = new JButton(new AbstractAction("Aggiungi"){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    User selectedUser = (User)usersList.getSelectedItem();
                    Smistamento.this.model.addUserOrder(new UserOrder(selectedUser));
                    Smistamento.this.model.getUsersWithOrder().add(selectedUser.getId());
                    ((SummaryBodyTableModel)Smistamento.this.summaryBodyTable.getModel()).fireTableStructureChanged();
                    ((SummaryFooterTableModel)Smistamento.this.footerTable.getModel()).fireTableStructureChanged();
                    newUserDialog.setVisible(false);
                }
            });
            buttonsPanel.add((Component)ok, "West");
            JButton cancel = new JButton(new AbstractAction("Annulla"){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    newUserDialog.setVisible(false);
                }
            });
            buttonsPanel.add((Component)cancel, "East");
            newUserDialog.add((Component)buttonsPanel, "South");
            newUserDialog.pack();
            newUserDialog.setVisible(true);
        }
    };
    private Action completeItemAction = new AbstractAction("Prodotto completato"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            int selectedRow = Smistamento.this.summaryBodyTable.getSelectedRow();
            if (selectedRow > -1) {
                OrderItem item;
                item.setFinished(!(item = Smistamento.this.model.getOrderItem(selectedRow)).isFinished());
                ((AbstractTableModel)Smistamento.this.summaryBodyTable.getModel()).fireTableDataChanged();
                ((SummaryFooterTableModel)Smistamento.this.footerTable.getModel()).fireTableStructureChanged();
                Smistamento.this.summaryBodyTable.getTableHeader().repaint();
            }
        }
    };
    private Action distributeQuantity = new AbstractAction("Distribuisci quantit\u00e0"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            int selectedRow = Smistamento.this.summaryBodyTable.getSelectedRow();
            if (selectedRow > -1) {
                ((SummaryBodyTableModel)Smistamento.this.summaryBodyTable.getModel()).distributeItemQty(selectedRow);
            }
        }
    };
    private Action automaticallyDistributeQuantity = new AbstractAction("Distribuisci automaticamente quantit\u00e0"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent event) {
            JMenuItem checkboxMenuItem = (JMenuItem)event.getSource();
            Smistamento.this.preferences.setAutomaticallyDistributeQty(checkboxMenuItem.isSelected());
        }
    };
    private Action downloadAction = new AbstractAction("Apri da Go!Gas"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DownloadDialog dialog = new DownloadDialog(Smistamento.this.self, Smistamento.this.preferences);
            dialog.showOrderSelection();
        }
    };
    private Action uploadAction = new AbstractAction("Invia a Go!Gas"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (JOptionPane.showConfirmDialog(Smistamento.this.self, "Il file verr\u00e0 salvato ed inviato a Go!Gas per l'aggiornamento delle quantit\u00e0 smistate. Continuare?", "Invio a Go!Gas", 2, 3) == 0) {
                    Smistamento.this.model.saveOnFile(Smistamento.this.currentFile);
                    DownloadDialog dialog = new DownloadDialog(Smistamento.this.self, Smistamento.this.preferences);
                    dialog.sendOrder(Smistamento.this.model.getIdDataOrdine(), Smistamento.this.currentFile);
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(Smistamento.this.self, "Errore durante il salvataggio su file: " + e1.getClass().getSimpleName() + " - " + e1.getMessage(), "Errore salvataggio", 0);
                e1.printStackTrace();
            }
        }
    };
    private Action connectionSettingsAction = new AbstractAction("Connessione a Go!Gas"){
        private static final long serialVersionUID = 0L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectionPanel connectionPanel = new ConnectionPanel(Smistamento.this.preferences);
            connectionPanel.getConnectionParams(null, "Salva");
        }
    };
    private List<Action> columnActions = new ArrayList<Action>();
    private JMenuBar menuBar;
    private PackableTable summaryBodyTable;
    private PackableTable summaryLeftTable;
    private SummaryHeaderTableModel headerTableModel;
    private JTable footerTable;
    private JFrame self = this;
    private JMenuItem viewColumnMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem pasteMenuItem;
    private JLabel totaleOrdinato;
    private JLabel totaleSmistato;
    private JSplitPane summarySplitPane;
    private SmistamentoModel model;
    private Preferences preferences = new Preferences();

    public Smistamento(String[] args) throws Exception {
        this.preferences.loadFromFile();
        this.createMenu();
        this.setTitle(WINDOW_TITLE);
        this.setSize(800, 600);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Smistamento.this.exit();
            }
        });
        if (args.length > 0) {
            this.openFile(new File(args[0]));
        }
        this.setVisible(true);
    }

    private void createMenu() {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("File");
        this.menuBar.add(menu);
        JMenuItem openMenuItem = new JMenuItem(this.fileOpenAction);
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        openMenuItem.getAccessibleContext().setAccessibleDescription("Apri un nuovo file");
        menu.add(openMenuItem);
        JMenuItem saveMenuItem = new JMenuItem(this.saveAction);
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveMenuItem.getAccessibleContext().setAccessibleDescription("Salva file");
        menu.add(saveMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem(this.saveAsAction);
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        saveAsMenuItem.getAccessibleContext().setAccessibleDescription("Salva file come...");
        menu.add(saveAsMenuItem);
        JMenuItem closeMenuItem = new JMenuItem(this.closeAction);
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        closeMenuItem.getAccessibleContext().setAccessibleDescription("Salva file come...");
        menu.add(closeMenuItem);
        menu.addSeparator();
        JMenuItem downloadMenuItem = new JMenuItem(this.downloadAction);
        downloadMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        downloadMenuItem.getAccessibleContext().setAccessibleDescription("Apri da Go!Gas");
        menu.add(downloadMenuItem);
        JMenuItem uploadMenuItem = new JMenuItem(this.uploadAction);
        uploadMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        uploadMenuItem.getAccessibleContext().setAccessibleDescription("Invia a Go!Gas");
        menu.add(uploadMenuItem);
        menu.addSeparator();
        JMenuItem mergeMenuItem = new JMenuItem(this.mergeAction);
        mergeMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        mergeMenuItem.getAccessibleContext().setAccessibleDescription("Unisci due file");
        menu.add(mergeMenuItem);
        menu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem(this.exitAction);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        exitMenuItem.getAccessibleContext().setAccessibleDescription("Esci dall'applicazione");
        menu.add(exitMenuItem);
        JMenu edit = new JMenu("Modifica");
        edit.setMnemonic(77);
        edit.getAccessibleContext().setAccessibleDescription("Modifica");
        this.menuBar.add(edit);
        JMenuItem addUserMenuItem = new JMenuItem(this.addNewUserAction);
        addUserMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        addUserMenuItem.getAccessibleContext().setAccessibleDescription("Aggiungi un nuovo utente");
        edit.add(addUserMenuItem);
        JMenuItem completeUserMenuItem = new JMenuItem(this.completeUserAction);
        completeUserMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        completeUserMenuItem.getAccessibleContext().setAccessibleDescription("Utente completato");
        edit.add(completeUserMenuItem);
        edit.addSeparator();
        JMenuItem completeItemMenuItem = new JMenuItem(this.completeItemAction);
        completeItemMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        completeItemMenuItem.getAccessibleContext().setAccessibleDescription("Prodotto completato");
        edit.add(completeItemMenuItem);
        edit.addSeparator();
        this.undoManager.setLimit(200);
        JMenuItem undoMenuItem = new JMenuItem(this.undoAction);
        undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        undoMenuItem.getAccessibleContext().setAccessibleDescription("Undo");
        edit.add(undoMenuItem);
        JMenuItem redoMenuItem = new JMenuItem(this.redoAction);
        redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        redoMenuItem.getAccessibleContext().setAccessibleDescription("Redo");
        edit.add(redoMenuItem);
        edit.addSeparator();
        TransferActionListener actionListener = new TransferActionListener();
        this.cutMenuItem = new JMenuItem("Cut");
        this.cutMenuItem.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
        this.cutMenuItem.addActionListener(actionListener);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setMnemonic(84);
        edit.add(this.cutMenuItem);
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        this.copyMenuItem.addActionListener(actionListener);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setMnemonic(67);
        edit.add(this.copyMenuItem);
        this.pasteMenuItem = new JMenuItem("Paste");
        this.pasteMenuItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
        this.pasteMenuItem.addActionListener(actionListener);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic(80);
        edit.add(this.pasteMenuItem);
        edit.addSeparator();
        JMenuItem distributeQuantityMenuItem = new JMenuItem(this.distributeQuantity);
        distributeQuantityMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        distributeQuantityMenuItem.getAccessibleContext().setAccessibleDescription("Distribuisci quantit\u00e0");
        edit.add(distributeQuantityMenuItem);
        JCheckBoxMenuItem automaticallyDistributeQuantityMenuItem = new JCheckBoxMenuItem(this.automaticallyDistributeQuantity);
        ((JMenuItem)automaticallyDistributeQuantityMenuItem).getAccessibleContext().setAccessibleDescription("Distribuisci automaticamente le quantit\u00e0 al variare del peso reale");
        automaticallyDistributeQuantityMenuItem.setSelected(this.preferences.isAutomaticallyDistributeQty());
        edit.add(automaticallyDistributeQuantityMenuItem);
        JMenu view = new JMenu("Visualizza");
        view.setMnemonic(86);
        view.getAccessibleContext().setAccessibleDescription("Visualizza");
        this.menuBar.add(view);
        this.viewColumnMenuItem = new JMenu("Colonne");
        this.viewColumnMenuItem.getAccessibleContext().setAccessibleDescription("Visualizza colonne");
        view.add(this.viewColumnMenuItem);
        JMenu settings = new JMenu("Impostazioni");
        settings.setMnemonic(73);
        settings.getAccessibleContext().setAccessibleDescription("Impostazioni");
        this.menuBar.add(settings);
        JMenuItem connectionSettingsMenuItem = new JMenuItem(this.connectionSettingsAction);
        connectionSettingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        connectionSettingsMenuItem.getAccessibleContext().setAccessibleDescription("Connessione a Go!Gas");
        settings.add(connectionSettingsMenuItem);
        JMenu help = new JMenu("?");
        help.setMnemonic(72);
        help.getAccessibleContext().setAccessibleDescription("Aiuto");
        this.menuBar.add(help);
        JMenuItem versionMenuItem = new JMenuItem(this.versionAction);
        versionMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        versionMenuItem.getAccessibleContext().setAccessibleDescription("Visualizza versione applicazione");
        help.add(versionMenuItem);
        this.setEnabledFileActions(false);
        this.setJMenuBar(this.menuBar);
    }

    private JFileChooser createFileChooser(String approveButtonText) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(this.inputFileFilter);
        if (approveButtonText != null) {
            fileChooser.setApproveButtonText(approveButtonText);
        }
        if (this.preferences.getLastOpenedDir() != null) {
            fileChooser.setCurrentDirectory(this.preferences.getLastOpenedDir());
        }
        return fileChooser;
    }

    protected void setEnabledFileActions(boolean enabled) {
        this.saveAction.setEnabled(enabled);
        this.saveAsAction.setEnabled(enabled);
        this.closeAction.setEnabled(enabled);
        this.mergeAction.setEnabled(enabled);
        this.undoAction.setEnabled(enabled);
        this.redoAction.setEnabled(enabled);
        for (Action columnAction : this.columnActions) {
            columnAction.setEnabled(enabled);
        }
        this.addNewUserAction.setEnabled(enabled);
        this.completeUserAction.setEnabled(enabled);
        this.completeItemAction.setEnabled(enabled);
        this.distributeQuantity.setEnabled(enabled);
        this.copyMenuItem.setEnabled(enabled);
        this.cutMenuItem.setEnabled(enabled);
        this.pasteMenuItem.setEnabled(enabled);
        this.uploadAction.setEnabled(enabled && this.model != null && this.model.getIdDataOrdine() != null);
    }

    protected void openFile(File inputFile) throws Exception {
        this.model = SmistamentoModel.parseFile(inputFile);
        this.headerTableModel = new SummaryHeaderTableModel(this.model, this.preferences);
        this.viewColumnMenuItem.removeAll();
        this.columnActions.clear();
        int i = 3;
        while (i < SummaryHeaderTableModel.MENU_COLUMN_NAMES.length) {
            ShowColumnAction columnAction = new ShowColumnAction(SummaryHeaderTableModel.MENU_COLUMN_NAMES[i], i - 3, this.headerTableModel, this.preferences);
            this.columnActions.add(columnAction);
            JCheckBoxMenuItem columnMenuItem = new JCheckBoxMenuItem(columnAction);
            columnMenuItem.setAccelerator(KeyStroke.getKeyStroke(48 + i - 2, 2));
            columnMenuItem.setSelected(this.preferences.isColumnVisible(i - 3));
            this.viewColumnMenuItem.add(columnMenuItem);
            ++i;
        }
        this.summaryLeftTable = new PackableTable((TableModel)this.headerTableModel, 1, true);
        JScrollPane scrollPaneHeader = new JScrollPane(this.summaryLeftTable);
        scrollPaneHeader.setVerticalScrollBarPolicy(21);
        this.summaryLeftTable.setDefaultEditor(Object.class, new DefaultCellEditor(new OverwriteJTextField()));
        this.summaryLeftTable.addKeyListener(new DigitKeyListener());
        this.summaryLeftTable.setFillsViewportHeight(true);
        this.summaryLeftTable.getTableHeader().setReorderingAllowed(false);
        this.summaryLeftTable.setSelectionMode(0);
        this.headerTableModel.setColumnModel(this.summaryLeftTable.getColumnModel());
        this.summaryLeftTable.pack();
        JLabel totale = new JLabel("TOTALE:    ");
        totale.setOpaque(true);
        totale.setBackground(Color.ORANGE);
        totale.setForeground(Color.DARK_GRAY);
        totale.setFont(totale.getFont().deriveFont(1));
        totale.setPreferredSize(new Dimension((int)totale.getPreferredSize().getWidth(), 34));
        totale.setHorizontalAlignment(4);
        totale.setVerticalAlignment(1);
        this.totaleOrdinato = new JLabel("Totale ordinato:           " + currencyDecimalFormat.format(this.model.getTotalOrdered()));
        this.totaleOrdinato.setOpaque(true);
        this.totaleOrdinato.setBackground(Color.ORANGE);
        this.totaleOrdinato.setForeground(Color.DARK_GRAY);
        this.totaleOrdinato.setFont(totale.getFont().deriveFont(1));
        this.totaleOrdinato.setVerticalAlignment(1);
        this.totaleSmistato = new JLabel("Totale smistamento: " + currencyDecimalFormat.format(this.model.getTotalDispatched()));
        this.totaleSmistato.setOpaque(true);
        this.totaleSmistato.setBackground(Color.ORANGE);
        this.totaleSmistato.setForeground(Color.DARK_GRAY);
        this.totaleSmistato.setFont(totale.getFont().deriveFont(1));
        this.totaleSmistato.setVerticalAlignment(1);
        JPanel leftSouthTotalsPane = new JPanel(new BorderLayout());
        leftSouthTotalsPane.setBackground(Color.ORANGE);
        leftSouthTotalsPane.setOpaque(true);
        leftSouthTotalsPane.add((Component)this.totaleOrdinato, "North");
        leftSouthTotalsPane.add((Component)this.totaleSmistato, "South");
        JPanel leftSouthPane = new JPanel(new BorderLayout());
        leftSouthPane.setBackground(Color.ORANGE);
        leftSouthPane.setOpaque(true);
        leftSouthPane.add((Component)totale, "Center");
        leftSouthPane.add((Component)leftSouthTotalsPane, "West");
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setBackground(Color.ORANGE);
        leftPane.setOpaque(true);
        leftPane.add((Component)scrollPaneHeader, "Center");
        leftPane.add((Component)leftSouthPane, "South");
        SummaryBodyTableModel summaryBodyTableModel = new SummaryBodyTableModel(this.model, this.undoManager);
        this.headerTableModel.setSummaryBodyTableModel(summaryBodyTableModel);
        this.summaryBodyTable = new PackableTable((TableModel)summaryBodyTableModel, 1, true);
        this.summaryBodyTable.setSelectionMode(1);
        this.summaryBodyTable.setDefaultRenderer(Object.class, new SummaryBodyTableCellRenderer(this.model));
        this.summaryBodyTable.pack();
        this.summaryBodyTable.setSize(this.summaryBodyTable.getPreferredSize());
        this.summaryBodyTable.doLayout();
        this.summaryBodyTable.setAutoResizeMode(0);
        this.summaryBodyTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane bodyScrollPane = new JScrollPane(this.summaryBodyTable);
        bodyScrollPane.setHorizontalScrollBarPolicy(31);
        this.summaryBodyTable.setFillsViewportHeight(true);
        ActionMap map = this.summaryBodyTable.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        TableTransferHandler tth = new TableTransferHandler(this.undoManager);
        this.summaryBodyTable.setTransferHandler(tth);
        String[] tooltips = new String[this.model.getUserOrderCount()];
        int i2 = 0;
        while (i2 < this.model.getUserOrderCount()) {
            tooltips[i2] = this.model.getUserOrder(i2).getUser().toString();
            ++i2;
        }
        this.summaryBodyTable.setTooltips(tooltips);
        this.summaryBodyTable.setDefaultEditor(Object.class, new DefaultCellEditor(new OverwriteJTextField()));
        this.summaryBodyTable.addKeyListener(new DigitKeyListener());
        this.summaryLeftTable.getTableHeader().setPreferredSize(new Dimension((int)this.summaryLeftTable.getTableHeader().getPreferredSize().getWidth(), (int)this.summaryBodyTable.getTableHeader().getPreferredSize().getHeight()));
        this.footerTable = new JTable(new SummaryFooterTableModel(this.model));
        this.footerTable.getTableHeader().setVisible(false);
        this.footerTable.getTableHeader().setPreferredSize(new Dimension(-1, 0));
        this.footerTable.setSize(this.summaryBodyTable.getPreferredSize());
        this.footerTable.doLayout();
        this.footerTable.setAutoResizeMode(0);
        JScrollPane footerScrollPane = new JScrollPane(this.footerTable);
        footerScrollPane.setPreferredSize(new Dimension((int)footerScrollPane.getPreferredSize().getWidth(), 34));
        footerScrollPane.setHorizontalScrollBarPolicy(32);
        footerScrollPane.getHorizontalScrollBar().addAdjustmentListener(new TableAdjustmentListener(bodyScrollPane.getHorizontalScrollBar()));
        bodyScrollPane.getHorizontalScrollBar().addAdjustmentListener(new TableAdjustmentListener(footerScrollPane.getHorizontalScrollBar()));
        JTableHeader summaryBodyTableHeader = this.summaryBodyTable.getTableHeader();
        SummaryBodyTableHeaderRenderer headerRenderer = new SummaryBodyTableHeaderRenderer(summaryBodyTableHeader.getDefaultRenderer(), this.model, (AbstractTableModel)this.footerTable.getModel(), this.summaryBodyTable);
        summaryBodyTableHeader.setDefaultRenderer(headerRenderer);
        summaryBodyTableHeader.addMouseListener(headerRenderer);
        JPanel rightPane = new JPanel(new BorderLayout());
        rightPane.add((Component)bodyScrollPane, "Center");
        rightPane.add((Component)footerScrollPane, "South");
        SummaryHeaderTableCellRenderer summaryHeaderCellRenderer = new SummaryHeaderTableCellRenderer(this.summaryBodyTable, this.model);
        this.summaryLeftTable.setDefaultRenderer(Object.class, summaryHeaderCellRenderer);
        this.summaryLeftTable.addMouseListener(summaryHeaderCellRenderer);
        this.footerTable.setDefaultRenderer(Object.class, new SummaryFooterTableCellRenderer(this.summaryBodyTable, this.model));
        bodyScrollPane.getVerticalScrollBar().addAdjustmentListener(new TableAdjustmentListener(scrollPaneHeader.getVerticalScrollBar()));
        scrollPaneHeader.getVerticalScrollBar().addAdjustmentListener(new TableAdjustmentListener(bodyScrollPane.getVerticalScrollBar()));
        RepaintSelectionListener summaryTableSelectionListener = new RepaintSelectionListener(null, this.summaryBodyTable, this.footerTable, this.summaryLeftTable);
        this.summaryBodyTable.getSelectionModel().addListSelectionListener(summaryTableSelectionListener);
        this.summaryBodyTable.getColumnModel().addColumnModelListener(summaryTableSelectionListener);
        this.summaryLeftTable.getSelectionModel().addListSelectionListener(new SummaryHeaderRepaintSelectionListener(this.summaryBodyTable, this.summaryLeftTable));
        summaryBodyTableModel.setExternalTableModel((AbstractTableModel)this.summaryLeftTable.getModel(), (AbstractTableModel)this.footerTable.getModel());
        summaryBodyTableModel.setTotalLabel(this.totaleSmistato);
        ((SummaryHeaderTableModel)this.summaryLeftTable.getModel()).setTotalLabel(this.totaleOrdinato);
        this.summarySplitPane = new JSplitPane(1, leftPane, rightPane);
        this.summarySplitPane.setDividerSize(2);
        this.summarySplitPane.setDividerLocation(450);
        this.summarySplitPane.setContinuousLayout(true);
        this.summarySplitPane.addPropertyChangeListener(new SplitDividerListener(this.summaryLeftTable));
        this.self.getContentPane().removeAll();
        this.self.getContentPane().add(this.summarySplitPane);
        this.headerTableModel.setSplitPane(this.summarySplitPane);
        FileUtil.copyFile(inputFile, new File(String.valueOf(inputFile.getAbsolutePath()) + ".bak"));
        this.currentFile = inputFile;
        this.self.setTitle("Gestione smistamento - " + this.currentFile.getAbsolutePath());
        this.setEnabledFileActions(true);
        SwingUtilities.updateComponentTreeUI(this.self.getContentPane());
    }

    private void exit() {
        if (JOptionPane.showConfirmDialog(null, "Uscire dall'applicazione?", "Uscita", 0) == 1) {
            return;
        }
        this.preferences.save();
        if (this.currentFile == null) {
            System.exit(0);
        }
        int result = JOptionPane.showConfirmDialog(this.self, "Salvare prima di uscire dall'applicazione?", "Attenzione", 1);
        switch (result) {
            case 0: {
                try {
                    this.model.saveOnFile(this.currentFile);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            case 1: {
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Smistamento(args);
    }
}

