/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.gastabien.model.SmistamentoModel;
import org.gastabien.model.SummaryBodyTableModel;

public class SummaryBodyTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color PACKAGE_COLOR = new Color(235, 198, 245);
    private static final Color PACKAGE_COLUMN_HIGHLIGHT_COLOR = new Color(173, 127, 186);
    private static final Color PACKAGE_CELL_HIGHLIGHT_COLOR = new Color(134, 15, 166);
    private static final Color FINISHED_COLOR = new Color(211, 240, 168);
    private static final Color FINISHED_COLUMN_HIGHLIGHT_COLOR = new Color(176, 209, 125);
    private static final Color FINISHED_CELL_HIGHLIGHT_COLOR = new Color(82, 130, 10);
    private SmistamentoModel smistamentoModel;

    public SummaryBodyTableCellRenderer(SmistamentoModel smistamentoModel) {
        this.smistamentoModel = smistamentoModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int selectedCol = table.getSelectedColumn();
        int selectedRow = table.getSelectedRow();
        List<Integer> selectedRangeCols = this.arrayToList(table.getSelectedColumns());
        List<Integer> selectedRangeRows = this.arrayToList(table.getSelectedRows());
        int packages = ((SummaryBodyTableModel)table.getModel()).getPackages(row, column);
        if (packages > 0) {
            ((JLabel)c).setText(String.valueOf(packages) + " cass" + (packages > 1 ? "e" : "a"));
        }
        if (column == selectedCol && row == selectedRow) {
            if (packages > 0) {
                c.setBackground(PACKAGE_CELL_HIGHLIGHT_COLOR);
            } else if (this.smistamentoModel.getUserOrder(column).isFinished() || this.smistamentoModel.getOrderItem(row).isFinished()) {
                c.setBackground(FINISHED_CELL_HIGHLIGHT_COLOR);
            } else {
                c.setBackground(Color.GRAY);
            }
            c.setForeground(Color.WHITE);
            c.setFont(this.getFont().deriveFont(1));
        } else if (selectedRangeCols.contains(column) && selectedRangeRows.contains(row)) {
            c.setForeground(Color.WHITE);
            c.setBackground(Color.BLUE);
            c.setFont(this.getFont().deriveFont(2));
        } else if (column == selectedCol || row == selectedRow) {
            if (packages > 0) {
                c.setBackground(PACKAGE_COLUMN_HIGHLIGHT_COLOR);
            } else if (this.smistamentoModel.getUserOrder(column).isFinished() || this.smistamentoModel.getOrderItem(row).isFinished()) {
                c.setBackground(FINISHED_COLUMN_HIGHLIGHT_COLOR);
            } else {
                c.setBackground(Color.LIGHT_GRAY);
            }
            c.setForeground(Color.WHITE);
            c.setFont(this.getFont().deriveFont(0));
        } else {
            if (packages > 0) {
                c.setBackground(PACKAGE_COLOR);
            } else if (this.smistamentoModel.getUserOrder(column).isFinished() || this.smistamentoModel.getOrderItem(row).isFinished()) {
                c.setBackground(FINISHED_COLOR);
            } else {
                c.setBackground(Color.WHITE);
            }
            c.setForeground(Color.BLACK);
            c.setFont(this.getFont().deriveFont(0));
        }
        if (((SummaryBodyTableModel)table.getModel()).valueChanged(row, column)) {
            c.setForeground(Color.RED);
            c.setFont(c.getFont().deriveFont(2));
        }
        ((JLabel)c).setHorizontalAlignment(0);
        return c;
    }

    private List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.add(i);
            ++n2;
        }
        return result;
    }
}

