/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.gastabien.model.SmistamentoModel;
import org.gastabien.model.UserOrder;

public class SummaryBodyTableHeaderRenderer
extends MouseAdapter
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color FINISHED_COLOR = new Color(115, 189, 4);
    private TableCellRenderer defaultHeaderCellRenderer;
    private SmistamentoModel smistamentoModel;
    private AbstractTableModel footerTableModel;
    private JTable summaryTable;

    public SummaryBodyTableHeaderRenderer(TableCellRenderer defaultHeaderCellRenderer, SmistamentoModel smistamentoModel, AbstractTableModel footerTableModel, JTable summaryTable) {
        this.defaultHeaderCellRenderer = defaultHeaderCellRenderer;
        this.smistamentoModel = smistamentoModel;
        this.footerTableModel = footerTableModel;
        this.summaryTable = summaryTable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.defaultHeaderCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ((JLabel)c).setHorizontalAlignment(0);
        UserOrder order = this.smistamentoModel.getUserOrder(column);
        if (order.isFinished()) {
            c.setBackground(FINISHED_COLOR);
        }
        return c;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            UserOrder order;
            TableColumnModel columnModel;
            int viewColumn;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(e.getX()));
            order.setFinished(!(order = this.smistamentoModel.getUserOrder(column)).isFinished());
            if (this.footerTableModel != null) {
                this.footerTableModel.fireTableCellUpdated(0, column);
            }
            if (this.summaryTable != null) {
                ((AbstractTableModel)this.summaryTable.getModel()).fireTableDataChanged();
                this.summaryTable.getTableHeader().repaint();
            }
        }
    }
}

