/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.gastabien.model.SmistamentoModel;

public class SummaryFooterTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color FINISHED_COLOR = new Color(115, 189, 4);
    private static final Color FINISHED_HIGHLIGHT_COLOR = new Color(82, 130, 10);
    private JTable bodyTable;
    private SmistamentoModel smistamentoModel;

    public SummaryFooterTableCellRenderer(JTable bodyTable, SmistamentoModel smistamentoModel) {
        this.bodyTable = bodyTable;
        this.smistamentoModel = smistamentoModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int selectedCol = this.bodyTable.getSelectedColumn();
        if (column == selectedCol) {
            c.setForeground(Color.WHITE);
            if (this.smistamentoModel.getUserOrder(column).isFinished()) {
                c.setBackground(FINISHED_HIGHLIGHT_COLOR);
            } else {
                c.setBackground(Color.RED);
            }
        } else {
            c.setForeground(Color.BLACK);
            if (this.smistamentoModel.getUserOrder(column).isFinished()) {
                c.setBackground(FINISHED_COLOR);
            } else {
                c.setBackground(Color.ORANGE);
            }
        }
        c.setFont(this.getFont().deriveFont(1));
        ((JLabel)c).setHorizontalAlignment(0);
        return c;
    }
}

