/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.gastabien.model.OrderItem;
import org.gastabien.model.SmistamentoModel;

public class SummaryHeaderTableCellRenderer
extends DefaultTableCellRenderer
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final Color FINISHED_COLOR = new Color(115, 189, 4);
    private static final Color FINISHED_HIGHLIGHT_COLOR = new Color(82, 130, 10);
    private static final Color FINISHED_STATS_COLOR = new Color(176, 209, 125);
    private JTable bodyTable;
    private SmistamentoModel smistamentoModel;

    public SummaryHeaderTableCellRenderer(JTable bodyTable, SmistamentoModel smistamentoModel) {
        this.bodyTable = bodyTable;
        this.smistamentoModel = smistamentoModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int selectedRow = this.bodyTable.getSelectedRow();
        OrderItem item = this.smistamentoModel.getOrderItem(row);
        if (row == selectedRow) {
            c.setForeground(Color.WHITE);
            c.setBackground(item != null && item.isFinished() ? FINISHED_HIGHLIGHT_COLOR : Color.RED);
            c.setFont(this.getFont().deriveFont(1));
        } else {
            switch (column) {
                case 0: 
                case 1: 
                case 2: {
                    if (item != null && item.isFinished()) {
                        c.setForeground(Color.DARK_GRAY);
                        c.setBackground(FINISHED_COLOR);
                    } else {
                        c.setForeground(Color.DARK_GRAY);
                        c.setBackground(Color.ORANGE);
                    }
                    c.setFont(this.getFont().deriveFont(1));
                    break;
                }
                default: {
                    if (item != null && item.isFinished()) {
                        c.setBackground(FINISHED_STATS_COLOR);
                    } else {
                        c.setBackground(new Color(250, 227, 172));
                    }
                    c.setForeground(Color.BLACK);
                    c.setFont(this.getFont().deriveFont(0));
                }
            }
        }
        switch (column) {
            case 0: {
                ((JLabel)c).setHorizontalAlignment(2);
                break;
            }
            case 1: {
                ((JLabel)c).setHorizontalAlignment(4);
                break;
            }
            case 2: {
                ((JLabel)c).setHorizontalAlignment(0);
                break;
            }
        }
        return c;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            OrderItem item;
            JTable table = (JTable)e.getSource();
            int rowIndex = table.rowAtPoint(e.getPoint());
            item.setFinished(!(item = this.smistamentoModel.getOrderItem(rowIndex)).isFinished());
            ((AbstractTableModel)table.getModel()).fireTableRowsUpdated(rowIndex, rowIndex);
            if (this.bodyTable != null) {
                ((AbstractTableModel)this.bodyTable.getModel()).fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

