/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TablePacker {
    public static final int VISIBLE_ROWS = 0;
    public static final int ALL_ROWS = 1;
    public static final int NO_ROWS = 2;
    private int rowsIncluded = 0;
    private boolean distributeExtraArea = true;

    public TablePacker(int rowsIncluded, boolean distributeExtraArea) {
        this.rowsIncluded = rowsIncluded;
        this.distributeExtraArea = distributeExtraArea;
    }

    private int preferredWidth(JTable table, int col) {
        TableColumn tableColumn = table.getColumnModel().getColumn(col);
        int width = (int)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
        if (table.getRowCount() != 0) {
            int from = 0;
            int to = 0;
            if (this.rowsIncluded == 0) {
                Rectangle rect = table.getVisibleRect();
                from = table.rowAtPoint(rect.getLocation());
                to = table.rowAtPoint(new Point((int)rect.getMaxX(), (int)rect.getMaxY())) + 1;
                if (to == 0) {
                    to = table.getRowCount();
                }
            } else if (this.rowsIncluded == 1) {
                from = 0;
                to = table.getRowCount();
            }
            int row = from;
            while (row < to) {
                int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
                ++row;
            }
        }
        return width + table.getIntercellSpacing().width;
    }

    public void pack(JTable table) {
        if (!table.isShowing()) {
            return;
        }
        if (table.getColumnCount() == 0) {
            return;
        }
        int[] width = new int[table.getColumnCount()];
        int total = 0;
        int col = 0;
        while (col < width.length) {
            width[col] = this.preferredWidth(table, col);
            total += width[col];
            ++col;
        }
        int extra = table.getVisibleRect().width - total;
        if (extra > 0) {
            if (this.distributeExtraArea) {
                int bonus = extra / table.getColumnCount();
                int i = 0;
                while (i < width.length) {
                    int n = i++;
                    width[n] = width[n] + bonus;
                }
                extra -= bonus * table.getColumnCount();
            }
            int n = width.length - 1;
            width[n] = width[n] + extra;
        }
        int totResized = 0;
        TableColumnModel columnModel = table.getColumnModel();
        int col2 = 0;
        while (col2 < width.length && totResized <= table.getVisibleRect().width) {
            TableColumn tableColumn = columnModel.getColumn(col2);
            table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width[col2]);
            totResized += width[col2];
            ++col2;
        }
    }
}

