/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.UndoManager;
import org.gastabien.model.MultipleUndoableEdit;
import org.gastabien.model.SummaryBodyTableModel;

public class TableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private UndoManager undoManager;

    public TableTransferHandler(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        String data = null;
        if (!this.canImport(info)) {
            return false;
        }
        JTable table = (JTable)info.getComponent();
        SummaryBodyTableModel model = (SummaryBodyTableModel)table.getModel();
        try {
            data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException ioe) {
            System.out.println("importData: I/O exception");
            return false;
        }
        if (info.isDrop()) {
            System.out.println("drop not supported");
            return false;
        }
        int col = table.getSelectedColumn();
        int row = table.getSelectedRow();
        if (JOptionPane.showConfirmDialog(table, "I valori verranno sovrascritti a partire dalla cella selezionata, continuare?", "Incolla", 0) == 1) {
            return false;
        }
        ArrayList matrice = new ArrayList();
        try {
            BufferedReader br = new BufferedReader(new StringReader(data));
            String line = br.readLine();
            while (line != null) {
                ArrayList<String> lineaMatrice = new ArrayList<String>();
                String[] stringArray = line.split("\t", -1);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.length() != 0 && !token.matches("|\\d+(,|\\.)\\d*")) {
                        JOptionPane.showMessageDialog(table, "Le informazioni incollate contengono dei valori non numerici", "Errore", 0);
                        return false;
                    }
                    lineaMatrice.add(token);
                    ++n2;
                }
                matrice.add(lineaMatrice);
                line = br.readLine();
            }
            if (row + matrice.size() > table.getRowCount() || col + ((ArrayList)matrice.get(0)).size() > table.getColumnCount()) {
                JOptionPane.showMessageDialog(table, "Le informazioni incollate eccedono i limiti della tabella", "Errore", 0);
                return false;
            }
            MultipleUndoableEdit undoableItem = new MultipleUndoableEdit(model);
            int i = 0;
            while (i < matrice.size()) {
                ArrayList lineaMatrice = (ArrayList)matrice.get(i);
                int j = 0;
                while (j < lineaMatrice.size()) {
                    String oldValueStr = (String)model.getValueAt(row + i, col + j);
                    model.setValueAt(lineaMatrice.get(j), row + i, col + j, false);
                    undoableItem.addCell(row + i, col + j, oldValueStr == null ? "" : oldValueStr, (String)lineaMatrice.get(j));
                    ++j;
                }
                ++i;
            }
            this.undoManager.addEdit(undoableItem);
            model.fireTableDataChanged();
            table.setColumnSelectionInterval(col, col + ((ArrayList)matrice.get(0)).size() - 1);
            table.setRowSelectionInterval(row, row + matrice.size() - 1);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTable table = (JTable)c;
        int[] cols = table.getSelectedColumns();
        int[] rows = table.getSelectedRows();
        String selection = "";
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            int[] nArray2 = cols;
            int n3 = cols.length;
            int n4 = 0;
            while (n4 < n3) {
                int col = nArray2[n4];
                Object value = table.getValueAt(row, col);
                selection = String.valueOf(selection) + (value != null ? value.toString() : "") + "\t";
                ++n4;
            }
            selection = String.valueOf(selection.substring(0, selection.length() - 1)) + "\r\n";
            ++n2;
        }
        return new StringSelection(selection);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action != 2) {
            return;
        }
        JTable table = (JTable)c;
        int col = table.getSelectedColumn();
        int row = table.getSelectedRow();
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.setValueAt("", row, col);
        model.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.stringFlavor);
    }
}

