/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtil {
    private static final int BUFFER_SIZE = 131072;

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void copyStream(InputStream input, OutputStream out, boolean closeInputStream) throws Exception {
        FileUtil.copyStream(input, out, closeInputStream, false);
    }

    public static void copyStream(InputStream input, OutputStream out, boolean closeInputStream, boolean nonBlocking) throws Exception {
        byte[] buffer = new byte[131072];
        if (nonBlocking && input.available() <= 0) {
            return;
        }
        int count = input.read(buffer, 0, 131072);
        while (count >= 0) {
            out.write(buffer, 0, count);
            if (nonBlocking && input.available() <= 0) break;
            count = input.read(buffer, 0, 131072);
        }
        out.flush();
        if (closeInputStream) {
            input.close();
        }
    }

    public static void copyStream(InputStream input, OutputStream out, long expectedSize) throws Exception {
        byte[] buffer = new byte[131072];
        int totalBytes = 0;
        int count = input.read(buffer, 0, (int)Math.min(131072L, expectedSize - (long)totalBytes));
        while (count >= 0) {
            out.write(buffer, 0, count);
            if ((long)(totalBytes += count) >= expectedSize) break;
            count = input.read(buffer, 0, (int)Math.min(131072L, expectedSize - (long)totalBytes));
        }
        out.flush();
    }
}

