/*
 * Decompiled with CFR 0.152.
 */
package org.gastabien.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Preferences {
    private static final String DEFAULT_PREFERENCE_FILE = "smistamento.properties";
    private List<Integer> visibleColumns = new ArrayList<Integer>();
    private File lastOpenedDir = null;
    private boolean automaticallyDistributeQty = false;
    private String goGasBaseUrl = null;
    private String goGasUsername = null;
    private String goGasPassword = null;

    public void loadFromFile() {
        String lastFileDialogPath;
        Properties props;
        block18: {
            props = new Properties();
            FileInputStream preferencesFileInputStream = null;
            try {
                try {
                    preferencesFileInputStream = new FileInputStream(DEFAULT_PREFERENCE_FILE);
                    props.load(preferencesFileInputStream);
                }
                catch (Exception e) {
                    System.out.println("Error while loading preferences, using default values");
                    if (preferencesFileInputStream != null) {
                        try {
                            preferencesFileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (preferencesFileInputStream != null) {
                    try {
                        preferencesFileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (preferencesFileInputStream != null) {
                try {
                    preferencesFileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (props.containsKey("visibleColumns")) {
            try {
                String[] tokens;
                String[] stringArray = tokens = props.getProperty("visibleColumns").split(",");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    this.visibleColumns.add(Integer.parseInt(token));
                    ++n2;
                }
            }
            catch (Exception e) {
                System.out.println("Error while loading visibleColumns preference, using default value");
                this.visibleColumns = new ArrayList<Integer>();
            }
        }
        this.lastOpenedDir = (lastFileDialogPath = props.getProperty("lastFileDialogPath")) != null ? new File(lastFileDialogPath) : null;
        this.automaticallyDistributeQty = Boolean.parseBoolean(props.getProperty("automaticallyDistributeQty"));
        this.goGasBaseUrl = props.getProperty("goGasBaseUrl");
        this.goGasUsername = props.getProperty("goGasUsername");
        this.goGasPassword = props.getProperty("goGasPassword");
    }

    public void save() {
        block13: {
            Properties props = new Properties();
            props.setProperty("visibleColumns", this.visibleColumns.toString().replace(" ", "").replace("[", "").replace("]", ""));
            if (this.lastOpenedDir != null) {
                props.setProperty("lastFileDialogPath", this.lastOpenedDir.getAbsolutePath());
            }
            props.setProperty("automaticallyDistributeQty", Boolean.toString(this.automaticallyDistributeQty));
            this.setProperty("goGasBaseUrl", this.goGasBaseUrl, props);
            this.setProperty("goGasUsername", this.goGasUsername, props);
            this.setProperty("goGasPassword", this.goGasPassword, props);
            FileOutputStream preferencesFileOutputStream = null;
            try {
                try {
                    preferencesFileOutputStream = new FileOutputStream(DEFAULT_PREFERENCE_FILE);
                    props.store(preferencesFileOutputStream, "");
                }
                catch (Exception e) {
                    System.out.println("Error while saving preferences");
                    if (preferencesFileOutputStream == null) break block13;
                    try {
                        preferencesFileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (preferencesFileOutputStream != null) {
                    try {
                        preferencesFileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void setProperty(String key, String value, Properties props) {
        if (key == null || value == null) {
            return;
        }
        props.setProperty(key, value);
    }

    public List<Integer> getVisibleColumns() {
        return this.visibleColumns;
    }

    public boolean isColumnVisible(Integer visibleColumnIndex) {
        return this.visibleColumns.contains(visibleColumnIndex);
    }

    public void setVisibleColumn(Integer visibleColumnIndex, boolean visible) {
        if (visibleColumnIndex == null) {
            return;
        }
        if (visible) {
            this.addVisibleColumns(visibleColumnIndex);
        } else {
            this.removeVisibleColumns(visibleColumnIndex);
        }
    }

    private void addVisibleColumns(Integer visibleColumnIndex) {
        if (!this.visibleColumns.contains(visibleColumnIndex)) {
            this.visibleColumns.add(visibleColumnIndex);
        }
    }

    private void removeVisibleColumns(Integer visibleColumnIndex) {
        if (this.visibleColumns.contains(visibleColumnIndex)) {
            this.visibleColumns.remove(visibleColumnIndex);
        }
    }

    public File getLastOpenedDir() {
        return this.lastOpenedDir;
    }

    public void setLastOpenedDir(File lastOpenedDir) {
        this.lastOpenedDir = lastOpenedDir;
    }

    public boolean isAutomaticallyDistributeQty() {
        return this.automaticallyDistributeQty;
    }

    public void setAutomaticallyDistributeQty(boolean automaticallyDistributeQty) {
        this.automaticallyDistributeQty = automaticallyDistributeQty;
    }

    public String getGoGasBaseUrl() {
        return this.goGasBaseUrl;
    }

    public void setGoGasBaseUrl(String goGasBaseUrl) {
        this.goGasBaseUrl = goGasBaseUrl;
    }

    public String getGoGasUsername() {
        return this.goGasUsername;
    }

    public void setGoGasUsername(String goGasUsername) {
        this.goGasUsername = goGasUsername;
    }

    public String getGoGasPassword() {
        return this.goGasPassword;
    }

    public void setGoGasPassword(String goGasPassword) {
        this.goGasPassword = goGasPassword;
    }
}

